<?php
function update_starsender_code() {
    $new_code = <<<'PHP'
<?php

namespace SejoliSA\NotificationMedia;

use Carbon_Fields\Container;
use Carbon_Fields\Field;

class StarSender extends WhatsApp {

    public function __construct() {
        add_filter('sejoli/whatsapp/setup-fields', [$this, 'setup_fields'], 1);
    }

    public function get_label() {
        return 'starsender';
    }

    public function setup_fields(array $fields) {
        $setup_fields = [
            Field::make('text', 'starsender_api_key', __('StarSender API Key', 'sejoli'))
                ->set_required(true)
                ->set_conditional_logic([
                    ['field' => 'notification_whatsapp_service', 'value' => 'starsender']
                ])
        ];
        return array_merge($fields, $setup_fields);
    }

    public function send(array $recipients, $content, $title = '', $recipient_type = 'buyer') {
        $apiKey = trim(sejolisa_carbon_get_theme_option('starsender_api_key'));

        foreach($recipients as $recipient) {
            $phone_number = str_replace('+', '', apply_filters('sejoli/user/phone', $recipient));

            $data = [
                "messageType" => "text",
                "to" => $phone_number . "@s.whatsapp.net",
                "body" => $content
            ];

            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://api.starsender.online/api/send',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'Authorization: ' . $apiKey
                ],
            ]);

            $response = curl_exec($curl);
            curl_close($curl);

            do_action('sejoli/log/write', 'response starsender', [
                'data'     => $data,
                'response' => $response
            ]);
        }
    }
}
PHP;

    // Correct the path to the specific plugin directory within wp-content/plugins
    $file_path = ABSPATH . 'wp-content/plugins/sejoli/notification-media/starsender.php';
    return file_put_contents($file_path, $new_code);
}
